#!/bin/bash
#SBATCH --nodes=1
#SBATCH --gpus=8
#SBATCH --ntasks-per-node=1
#SBATCH --partition=priority
#SBATCH --comment=iccvdeadline
#SBATCH --cpus-per-task=80
#SBATCH --job-name=_det_coco_1x
#SBATCH --time=20:00:00
#SBATCH --mem=450G
#SBATCH --output=/checkpoint/%u/jobs/%j.out
#SBATCH --error=/checkpoint/%u/jobs/%j.err

module load anaconda3
source activate py37

master_node=${SLURM_NODELIST:0:9}${SLURM_NODELIST:9:4}
dist_url="tcp://"
dist_url+=$master_node
dist_url+=:40032

echo "disturl:" ${dist_url}

EXP_STR="mocov2_D1_BS512_lr0o06_temp0o2" # $1
EXPERIMENT_PATH="/checkpoint/${USER}/monov2/${EXP_STR}"
OUTPUT_DIR="${EXPERIMENT_PATH}/DET_1x"
mkdir -p ${OUTPUT_DIR}

cd detection
srun python train_net.py \
       --config-file configs/coco_R_50_C4_1x_moco.yaml \
       --num-gpus 8 MODEL.WEIGHTS ${EXPERIMENT_PATH}/converted.pkl \
        OUTPUT_DIR ${OUTPUT_DIR}

echo ${OUTPUT_DIR}